[//lasso
	define_tag: 
		'akismet_auth', 
		-required='key', 
		-required='blog';
	
		local: 'result' = (include_url:
			'http://rest.akismet.com/1.1/verify-key',
			-postparams = (array: 'key' = #key, 'blog' = #blog)
		);
		
		if: #result >> 'valid';
			return: true;
		else;
			return: false;
		/if;
	/define_tag;


	define_tag: 
		'akismet_commentcheck',
		-required='key',
		-required='blog',
		-required='user_ip',
		-required='user_agent',
		-optional='referrer',
		-optional='permalink',
		-optional='comment_type',
		-optional='comment_author',
		-optional='comment_author_email',
		-optional='comment_author_url',
		-optional='comment_content';
		
		local: 'postparams' = array;
		
		iterate: params, local: 'i';
			if: #i->first != '-key';
				local: 'name' = #i->first;
				#name->(removeleading: '-');
				#postparams->(insert: #name = #i->second);
			/if;
		/iterate;
		
		local: 'result' = (include_url:
			'http://' + #key + '.rest.akismet.com/1.1/comment-check',
			-postparams = #postparams
		);
		
		if: #result >> 'true';
			return: true;
		else;
			return: false;
		/if;
	/define_tag;
	
	
	define_tag: 
		'akismet_submitspam',
		-required='key',
		-required='blog',
		-required='user_ip',
		-required='user_agent',
		-optional='referrer',
		-optional='permalink',
		-optional='comment_type',
		-optional='comment_author',
		-optional='comment_author_email',
		-optional='comment_author_url',
		-optional='comment_content';
		
		local: 'postparams' = array;
		
		iterate: params, local: 'i';
			if: #i->first != '-key';
				local: 'name' = #i->first;
				#name->(removeleading: '-');
				#postparams->(insert: #name = #i->second);
			/if;
		/iterate;
		
		local: 'result' = (include_url:
			'http://' + #key + '.rest.akismet.com/1.1/submit-spam',
			-postparams = #postparams
		);		
	/define_tag;


	define_tag: 
		'akismet_submitham',
		-required='key',
		-required='blog',
		-required='user_ip',
		-required='user_agent',
		-optional='referrer',
		-optional='permalink',
		-optional='comment_type',
		-optional='comment_author',
		-optional='comment_author_email',
		-optional='comment_author_url',
		-optional='comment_content';
		
		local: 'postparams' = array;
		
		iterate: params, local: 'i';
			if: #i->first != '-key';
				local: 'name' = #i->first;
				#name->(removeleading: '-');
				#postparams->(insert: #name = #i->second);
			/if;
		/iterate;
		
		local: 'result' = (include_url:
			'http://' + #key + '.rest.akismet.com/1.1/submit-ham',
			-postparams = #postparams
		);		
	/define_tag;


	define_tag(
		'akismet',
		-description='Placeholder for tagloader compatibility.'
	);
		return('Loaded.');
	/define_tag;


	/* SVN $Id: akismet.inc 262 2006-07-21 13:24:00Z Jason Huck $ */
]
